define(['app', 'angular'], function (app, angular) {

    app.directive('formControlWrapper', function (ErrorHandling) {
        return {
            restrict: 'A',
            require: ['^ngModel', '^form'],
            link:function(scope, elem, attrs, controllers) {
                var ngModelCtrl = controllers[0];
                var parentFormCtrl = controllers[1];
                
                var name = elem.parent().attr("name");
                var parentScope = elem.parent().scope();
                name = name && name.indexOf("{") !== -1 ? parentScope.$eval(name.replace("{{","").replace("}}", "")) : name;
                parentFormCtrl.$removeControl(ngModelCtrl);

                ngModelCtrl.$name = name;

                parentFormCtrl.$addControl(ngModelCtrl);
            }
        };
    });
});